package com.example.testdemo;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.util.Log;
import android.view.LayoutInflater;
import android.app.ProgressDialog;
import android.widget.Toast;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.lmx.library.media.VideoPlayAdapter;
import com.lmx.library.media.VideoPlayRecyclerView;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;

import io.dcloud.ads.core.entry.DCloudAdSlot;
import io.dcloud.ads.core.v2.draw.DCDrawAd;
import io.dcloud.ads.core.v2.draw.DCDrawAdListener;
import io.dcloud.ads.core.v2.draw.DCDrawAdLoadListener;
import io.dcloud.ads.core.v2.draw.DCDrawAdLoader;
import io.dcloud.ads.core.v2.feed.DCFeedAd;

public class DrawActivity extends AppCompatActivity {

    private VideoPlayRecyclerView drawLayout;
    private List<DrawEntry> drawEntries;
    private DrawAdapter adapter;
    private final int ITEM_COUNT = 10;

    ProgressDialog mProgressDialog;

    private void showLoading() {
        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(this);
            mProgressDialog.setMessage("正在加载...");
            mProgressDialog.setCanceledOnTouchOutside(false);
        }
        if (!mProgressDialog.isShowing()) {
            mProgressDialog.show();
        }
    }

    private void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_draw);
        drawLayout = this.findViewById(R.id.draw);
        drawEntries = new ArrayList<>();
        adapter = new DrawAdapter(drawEntries);
        drawLayout.setAdapter(adapter);
        load();
    }

    private void load(){
        showLoading();
        DCDrawAdLoader loader = new DCDrawAdLoader(this);
        DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("1616850538").build();
        loader.load(slot, new DCDrawAdLoadListener() {

            @Override
            public void onDrawAdLoad(List<DCDrawAd> list) {
                hideLoading();
                List<DrawEntry> refreshList = new ArrayList<>();
                for (int i = 0; i < ITEM_COUNT; i++) {
                    DrawEntry adEntry = new DrawEntry();
                    adEntry.text = "占位视频------" + i;
                    adEntry.type = 0;
                    refreshList.add(adEntry);
                }
                for (DCDrawAd ad : list) {
                    int index = (int) Math.abs(Math.random() * ITEM_COUNT);
                    refreshList.get(index).dcDrawAd = ad;
                    refreshList.get(index).type = 1;
                }
                drawEntries.addAll(refreshList);
                adapter.notifyDataSetChanged();
            }

            @Override
            public void onError(int i, String s, @Nullable JSONArray jsonArray) {
                hideLoading();
                Log.e("打印日志",i+s);
                Toast.makeText(DrawActivity.this, "加载失败: " + s + " code:" + i, Toast.LENGTH_SHORT).show();
            }
        });
    }

    private class DrawAdapter extends VideoPlayAdapter<DrawHolder> {

        private List<DrawEntry> entries;

        public DrawAdapter(List<DrawEntry> entries) {
            this.entries = entries;
        }

        @NonNull
        @Override
        public DrawHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_draw, parent, false);
            return new DrawHolder(view);
        }

        @Override
        public void onBindViewHolder(@NonNull DrawHolder holder, int position) {
            DrawEntry entry = entries.get(position);
            if (entry.type == 0) {
                holder.tv.setVisibility(View.VISIBLE);
                holder.rl.setVisibility(View.GONE);
                holder.rl.removeAllViews();
                holder.tv.setText(entry.text);
            } else {
                holder.tv.setVisibility(View.GONE);
                holder.rl.setVisibility(View.VISIBLE);
                holder.rl.removeAllViews();
                if (entry.drawView != null) {
                    ViewGroup parent = (ViewGroup) entry.drawView.getParent();
                    if (parent != null)
                        parent.removeView(entry.drawView);
                    holder.rl.addView(entry.drawView, new ViewGroup.LayoutParams(-1, -1));
                } else {
                    entry.dcDrawAd.setDrawAdListener(new DCDrawAdListener() {
                        @Override
                        public void onRenderSuccess() {
                            entry.drawView = entry.dcDrawAd.getDrawAdView(DrawActivity.this);
                            holder.rl.addView(entry.drawView, new ViewGroup.LayoutParams(-1, -1));
                        }

                        @Override
                        public void onRenderFail() {
                            holder.tv.setVisibility(View.VISIBLE);
                            holder.rl.setVisibility(View.GONE);
                        }

                        @Override
                        public void onClick() {

                        }

                        @Override
                        public void onShow() {

                        }

                        @Override
                        public void onClosed(String s) {

                        }

                        @Override
                        public void onShowError() {
                            Log.e("打印日志","onShowError");
                        }

                        @Override
                        public void onStart() {
                            Log.e("打印日志","onStart");
                        }

                        @Override
                        public void onPause() {
                            Log.e("打印日志","onPause");
                        }

                        @Override
                        public void onResume() {
                            Log.e("打印日志","onResume");
                        }

                        @Override
                        public void onEnd() {
                            Log.e("打印日志","onEnd");
                        }
                    });
                    entry.dcDrawAd.render();
                }
            }
        }

        @Override
        public int getItemCount() {
            return entries.size();
        }

        @Override
        public void onPageSelected(int itemPosition, View itemView) {
            if (itemPosition == entries.size() -1)
                load();
        }
    }

    private class DrawHolder extends RecyclerView.ViewHolder {

        TextView tv;
        RelativeLayout rl;

        public DrawHolder(@NonNull View itemView) {
            super(itemView);
            tv = itemView.findViewById(R.id.name);
            rl = itemView.findViewById(R.id.container);
        }
    }

    private class DrawEntry {
        private int type = 0;
        private String text;
        private DCDrawAd dcDrawAd;
        private View drawView;
    }
}