package com.example.testdemo;

import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.app.ProgressDialog;
import android.widget.Toast;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.example.testdemo.view.RefreshRecyclerView;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;

import io.dcloud.ads.core.entry.DCloudAdSlot;
import io.dcloud.ads.core.v2.feed.DCFeedAd;
import io.dcloud.ads.core.v2.feed.DCFeedAdListener;
import io.dcloud.ads.core.v2.feed.DCFeedAdLoadListener;
import io.dcloud.ads.core.v2.feed.DCFeedAdLoader;

public class FeedActivity extends AppCompatActivity {

    List<FeedEntry> entries;
    FeedAdapter myAdapter;
    int ITEM_COUNT = 10;
    private RefreshRecyclerView feedList;

    ProgressDialog mProgressDialog;

    private void showLoading() {
        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(this);
            mProgressDialog.setMessage("正在加载...");
            mProgressDialog.setCanceledOnTouchOutside(false);
        }
        if (!mProgressDialog.isShowing()) {
            mProgressDialog.show();
        }
    }

    private void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feed);
        feedList = this.findViewById(R.id.feedList);
        feedList.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        entries = new ArrayList<>();
        myAdapter = new FeedAdapter(entries);
        feedList.addItemDecoration(new FeedItemDecoration());
        feedList.setAdapter(myAdapter);
        feedList.setListener(this::load);
        load();
    }

    private void load() {
        showLoading();
        DCFeedAdLoader loader = new DCFeedAdLoader(this);
        DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("1000000001").build();
        loader.load(slot, new DCFeedAdLoadListener() {
            @Override
            public void onFeedAdLoad(List<DCFeedAd> list) {
                hideLoading();
                feedList.setLoadFinish();
                List<FeedEntry> refreshList = new ArrayList<>();
                for (int i = 0; i < ITEM_COUNT; i++) {
                    FeedEntry adEntry = new FeedEntry();
                    adEntry.name = "占位新闻列表------" + i;
                    adEntry.type = 0;
                    refreshList.add(adEntry);
                }
                for (DCFeedAd ad : list) {
                    int index = (int) Math.abs(Math.random() * ITEM_COUNT);
                    refreshList.get(index).feedAd = ad;
                    refreshList.get(index).type = 1;
                }
                entries.addAll(refreshList);
                myAdapter.notifyDataSetChanged();
            }

            @Override
            public void onError(int i, String s, @Nullable JSONArray jsonArray) {
                hideLoading();
                Log.e("打印日志",i+s+(jsonArray != null ? jsonArray.toString():""));
                feedList.setLoadFinish();
                Toast.makeText(FeedActivity.this, "加载失败: " + s + " code:" + i, Toast.LENGTH_SHORT).show();
            }
        });
    }

    private class FeedAdapter extends RecyclerView.Adapter<FeedViewHolder> {

        List<FeedEntry> entries = new ArrayList<>();

        public FeedAdapter(List<FeedEntry> entries) {
            this.entries = entries;
        }

        @NonNull
        @Override
        public FeedViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_feed, parent, false);
            return new FeedViewHolder(view);
        }

        @Override
        public void onBindViewHolder(@NonNull FeedViewHolder holder, int position) {
            FeedEntry entry = entries.get(position);
            if (entry.type == 0) {
                holder.tv.setVisibility(View.VISIBLE);
                holder.tv.setText(entry.name);
                holder.rl.setVisibility(View.GONE);
            } else {
                holder.tv.setVisibility(View.GONE);
                holder.rl.setVisibility(View.VISIBLE);
                holder.rl.removeAllViews();
                if (entry.feeView != null) {
                    if (entry.feeView.getParent() != null)
                        ((ViewGroup)(entry.feeView.getParent())).removeView(entry.feeView);
                    holder.rl.addView(entry.feeView, new ViewGroup.LayoutParams(-1, -2));
                } else {
                    entry.feedAd.setFeedAdListener(new DCFeedAdListener() {
                        @Override
                        public void onRenderSuccess() {
                            entry.feeView = entry.feedAd.getFeedAdView(FeedActivity.this);
                            holder.rl.addView(entry.feeView, new ViewGroup.LayoutParams(-1, -2));
                        }

                        @Override
                        public void onRenderFail() {
                            holder.tv.setVisibility(View.VISIBLE);
                            holder.rl.setVisibility(View.GONE);
                        }

                        @Override
                        public void onClick() {

                        }

                        @Override
                        public void onShow() {

                        }

                        @Override
                        public void onClosed(String s) {

                        }

                        @Override
                        public void onShowError() {

                        }
                    });
                    entry.feedAd.render();
                }
            }
        }

        @Override
        public int getItemCount() {
            return entries.size();
        }
    }

    private class FeedViewHolder extends RecyclerView.ViewHolder {

        TextView tv;
        RelativeLayout rl;

        public FeedViewHolder(@NonNull View itemView) {
            super(itemView);
            tv = itemView.findViewById(R.id.name);
            rl = itemView.findViewById(R.id.container);
        }
    }

    private class FeedEntry {

        int type = 0;
        String name;
        DCFeedAd feedAd;
        View feeView;
    }

    private class FeedItemDecoration extends RecyclerView.ItemDecoration {

        @Override
        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            outRect.set(0, 0, 0, 1);
        }
    }

}