package com.example.testdemo;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.app.ProgressDialog;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import org.json.JSONArray;
import org.json.JSONObject;

import io.dcloud.ads.core.DCloudAdManager;
import io.dcloud.ads.core.entry.DCloudAdSlot;
import io.dcloud.ads.core.v2.fullscreen.DCFullScreenAd;
import io.dcloud.ads.core.v2.fullscreen.DCFullScreenAdListener;
import io.dcloud.ads.core.v2.fullscreen.DCFullScreenAdLoadListener;
import io.dcloud.ads.core.v2.interstitial.DCInterstitialAd;
import io.dcloud.ads.core.v2.interstitial.DCInterstitialAdListener;
import io.dcloud.ads.core.v2.interstitial.DCInterstitialAdLoadListener;
import io.dcloud.ads.core.v2.reward.DCRewardAd;
import io.dcloud.ads.core.v2.reward.DCRewardAdListener;
import io.dcloud.ads.core.v2.reward.DCRewardAdLoadListener;

public class MainActivity extends AppCompatActivity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        this.findViewById(R.id.reward).setOnClickListener(v -> showReward());
        this.findViewById(R.id.interstital).setOnClickListener(v -> showInterstitial());
        this.findViewById(R.id.splash).setOnClickListener(v -> showSplash());
        this.findViewById(R.id.feed).setOnClickListener(v -> startActivity(new Intent(this, FeedActivity.class)));
        this.findViewById(R.id.draw).setOnClickListener(v -> startActivity(new Intent(this, DrawActivity.class)));
        this.findViewById(R.id.privacy).setOnClickListener(view -> startActivity(new Intent(this,PrivacyActivity.class)));
    }

    private void showSplash() {
        Intent intent = new Intent(this, SplashActivity.class);
        intent.putExtra("FROM", "MAIN");
        startActivity(intent);
    }

    ProgressDialog mProgressDialog;

    private void showLoading() {
        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(this);
            mProgressDialog.setMessage("正在加载...");
            mProgressDialog.setCanceledOnTouchOutside(false);
        }
        if (!mProgressDialog.isShowing()) {
            mProgressDialog.show();
        }
    }

    private void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
        }
    }


    DCInterstitialAd interstitialAd;

    private void showInterstitial() {
        showLoading();
        if (interstitialAd == null)
            interstitialAd = new DCInterstitialAd(this);
        DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("1563335904").build();
        interstitialAd.load(slot, new DCInterstitialAdLoadListener() {
            @Override
            public void onInterstitialAdLoad() {
                hideLoading();
                interstitialAd.setInterstitialAdListener(new DCInterstitialAdListener() {
                    @Override
                    public void onShow() {
                    }

                    @Override
                    public void onClick() {
                    }

                    @Override
                    public void onVideoPlayEnd() {
                    }

                    @Override
                    public void onSkip() {
                    }

                    @Override
                    public void onClose() {
                    }

                    @Override
                    public void onShowError(int i, String s) {
                        Log.e("打印日志",i+s);
                    }
                });
                interstitialAd.show(MainActivity.this);
            }

            @Override
            public void onError(int i, String s, @Nullable JSONArray jsonArray) {
                hideLoading();
                Log.e("打印日志",i+s+(jsonArray != null ? jsonArray.toString():""));
                Toast.makeText(MainActivity.this, "加载失败: " + s + " code:" + i, Toast.LENGTH_SHORT).show();
            }
        });
    }

    DCRewardAd rewardAd;

    private void showReward() {
        showLoading();
        if (rewardAd == null)
            rewardAd = new DCRewardAd(this);
        rewardAd.setRewardAdListener(new DCRewardAdListener() {
            @Override
            public void onReward(JSONObject jsonObject) {

            }

            @Override
            public void onShow() {
            }

            @Override
            public void onClick() {
            }

            @Override
            public void onVideoPlayEnd() {
            }

            @Override
            public void onSkip() {
            }

            @Override
            public void onClose() {
            }

            @Override
            public void onShowError(int i, String s) {
            }
        });
        DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("1974621980").build();
        rewardAd.load(slot, new DCRewardAdLoadListener() {
            @Override
            public void onRewardAdLoad() {
                hideLoading();
                rewardAd.show(MainActivity.this);
            }

            @Override
            public void onError(int i, String s, @Nullable JSONArray jsonArray) {
                hideLoading();
                Log.e("打印日志",i+s+(jsonArray != null ? jsonArray.toString():""));
                Toast.makeText(MainActivity.this, "加载失败: " + s + " code:" + i, Toast.LENGTH_SHORT).show();
            }
        });
    }
}
