package com.example.testdemo;

import android.content.SharedPreferences;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;

import io.dcloud.ads.core.DCloudAdManager;

public class PrivacyActivity extends AppCompatActivity {

    private static final String PREFS_NAME = "UniAdPrivacyPrefs";
    private CheckBox isAdultCheckBox;
    private CheckBox isCanUsePhoneStateCheckBox;
    private CheckBox isCanUseStorageCheckBox;
    private CheckBox isCanUseLocationCheckBox;
    private CheckBox isCanUseWifiStateCheckBox;
    private CheckBox isCanGetInstallAppListCheckBox;
    private CheckBox isCanGetRunningAppsCheckBox;
    private CheckBox isCanGetMacAddressCheckBox;
    private CheckBox isCanGetAndroidIdCheckBox;
    private CheckBox isCanGetOAIDCheckBox;
    private CheckBox isCanGetIPCheckBox;
    private CheckBox isCanUseSensorCheckBox;
    private CheckBox isCanUseSimOperatorCheckBox;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_privacy);

        LinearLayout layout = findViewById(R.id.layout);

        // 创建 CheckBox 并添加到布局中
        isAdultCheckBox = createCheckBox("是否是成年人");
        isCanUsePhoneStateCheckBox = createCheckBox("是否允许 SDK 主动使用手机硬件参数");
        isCanUseStorageCheckBox = createCheckBox("是否允许获取存储权限");
        isCanUseLocationCheckBox = createCheckBox("是否允许获取定位信息");
        isCanUseWifiStateCheckBox = createCheckBox("是否允许 SDK 主动使用 ACCESS_WIFI_STATE 权限");
        isCanGetInstallAppListCheckBox = createCheckBox("是否允许获取手机 app 安装列表");
        isCanGetRunningAppsCheckBox = createCheckBox("是否允许获取后台运行的 app 列表");
        isCanGetMacAddressCheckBox = createCheckBox("是否允许获取 mac 地址");
        isCanGetAndroidIdCheckBox = createCheckBox("是否允许获取 androidId");
        isCanGetOAIDCheckBox = createCheckBox("是否允许获取 oaid");
        isCanGetIPCheckBox = createCheckBox("是否允许获取 ip 地址");
        isCanUseSensorCheckBox = createCheckBox("是否允许使用手机传感器");
        isCanUseSimOperatorCheckBox = createCheckBox("是否允许获取运营商编码");

        layout.addView(isAdultCheckBox);
        layout.addView(isCanUsePhoneStateCheckBox);
        layout.addView(isCanUseStorageCheckBox);
        layout.addView(isCanUseLocationCheckBox);
        layout.addView(isCanUseWifiStateCheckBox);
        layout.addView(isCanGetInstallAppListCheckBox);
        layout.addView(isCanGetRunningAppsCheckBox);
        layout.addView(isCanGetMacAddressCheckBox);
        layout.addView(isCanGetAndroidIdCheckBox);
        layout.addView(isCanGetOAIDCheckBox);
        layout.addView(isCanGetIPCheckBox);
        layout.addView(isCanUseSensorCheckBox);
        layout.addView(isCanUseSimOperatorCheckBox);

        // 加载之前保存的状态
        loadPreferences();

        // 创建按钮并设置点击事件
        Button submitButton = findViewById(R.id.submit_button);
        submitButton.setOnClickListener(v -> {
            DCloudAdManager.PrivacyConfig config = new DCloudAdManager.PrivacyConfig() {
                @Override
                public boolean isAdult() {
                    return isAdultCheckBox.isChecked();
                }

                @Override
                public boolean isCanUsePhoneState() {
                    return isCanUsePhoneStateCheckBox.isChecked();
                }

                @Override
                public boolean isCanUseStorage() {
                    return isCanUseStorageCheckBox.isChecked();
                }

                @Override
                public boolean isCanUseLocation() {
                    return isCanUseLocationCheckBox.isChecked();
                }

                @Override
                public boolean isCanUseWifiState() {
                    return isCanUseWifiStateCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetInstallAppList() {
                    return isCanGetInstallAppListCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetRunningApps() {
                    return isCanGetRunningAppsCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetMacAddress() {
                    return isCanGetMacAddressCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetAndroidId() {
                    return isCanGetAndroidIdCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetOAID() {
                    return isCanGetOAIDCheckBox.isChecked();
                }

                @Override
                public boolean isCanGetIP() {
                    return isCanGetIPCheckBox.isChecked();
                }

                @Override
                public boolean isCanUseSensor() {
                    return isCanUseSensorCheckBox.isChecked();
                }

                @Override
                public boolean isCanUseSimOperator() {
                    return isCanUseSimOperatorCheckBox.isChecked();
                }
            };

            // 这里可以添加处理 config 对象的逻辑，例如打印配置信息
            System.out.println("isAdult: " + config.isAdult());
            System.out.println("isCanUsePhoneState: " + config.isCanUsePhoneState());
            System.out.println("isCanUseStorage: " + config.isCanUseStorage());
            System.out.println("isCanUseLocation: " + config.isCanUseLocation());
            System.out.println("isCanUseWifiState: " + config.isCanUseWifiState());
            System.out.println("isCanGetInstallAppList: " + config.isCanGetInstallAppList());
            System.out.println("isCanGetRunningApps: " + config.isCanGetRunningApps());
            System.out.println("isCanGetMacAddress: " + config.isCanGetMacAddress());
            System.out.println("isCanGetAndroidId: " + config.isCanGetAndroidId());
            System.out.println("isCanGetOAID: " + config.isCanGetOAID());
            System.out.println("isCanGetIP: " + config.isCanGetIP());
            System.out.println("isCanUseSensor: " + config.isCanUseSensor());
            System.out.println("isCanUseSimOperator: " + config.isCanUseSimOperator());

            DCloudAdManager.setPrivacyConfig(config);
            // 保存当前状态
            savePreferences();
        });
    }

    private CheckBox createCheckBox(String text) {
        CheckBox checkBox = new CheckBox(this);
        checkBox.setText(text);
        return checkBox;
    }

    private void loadPreferences() {
        SharedPreferences prefs = getSharedPreferences(PREFS_NAME, MODE_PRIVATE);
        isAdultCheckBox.setChecked(prefs.getBoolean("isAdult", false));
        isCanUsePhoneStateCheckBox.setChecked(prefs.getBoolean("isCanUsePhoneState", false));
        isCanUseStorageCheckBox.setChecked(prefs.getBoolean("isCanUseStorage", false));
        isCanUseLocationCheckBox.setChecked(prefs.getBoolean("isCanUseLocation", false));
        isCanUseWifiStateCheckBox.setChecked(prefs.getBoolean("isCanUseWifiState", false));
        isCanGetInstallAppListCheckBox.setChecked(prefs.getBoolean("isCanGetInstallAppList", false));
        isCanGetRunningAppsCheckBox.setChecked(prefs.getBoolean("isCanGetRunningApps", false));
        isCanGetMacAddressCheckBox.setChecked(prefs.getBoolean("isCanGetMacAddress", false));
        isCanGetAndroidIdCheckBox.setChecked(prefs.getBoolean("isCanGetAndroidId", false));
        isCanGetOAIDCheckBox.setChecked(prefs.getBoolean("isCanGetOAID", false));
        isCanGetIPCheckBox.setChecked(prefs.getBoolean("isCanGetIP", false));
        isCanUseSensorCheckBox.setChecked(prefs.getBoolean("isCanUseSensor", false));
        isCanUseSimOperatorCheckBox.setChecked(prefs.getBoolean("isCanUseSimOperator", false));
    }

    private void savePreferences() {
        SharedPreferences prefs = getSharedPreferences(PREFS_NAME, MODE_PRIVATE);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("isAdult", isAdultCheckBox.isChecked());
        editor.putBoolean("isCanUsePhoneState", isCanUsePhoneStateCheckBox.isChecked());
        editor.putBoolean("isCanUseStorage", isCanUseStorageCheckBox.isChecked());
        editor.putBoolean("isCanUseLocation", isCanUseLocationCheckBox.isChecked());
        editor.putBoolean("isCanUseWifiState", isCanUseWifiStateCheckBox.isChecked());
        editor.putBoolean("isCanGetInstallAppList", isCanGetInstallAppListCheckBox.isChecked());
        editor.putBoolean("isCanGetRunningApps", isCanGetRunningAppsCheckBox.isChecked());
        editor.putBoolean("isCanGetMacAddress", isCanGetMacAddressCheckBox.isChecked());
        editor.putBoolean("isCanGetAndroidId", isCanGetAndroidIdCheckBox.isChecked());
        editor.putBoolean("isCanGetOAID", isCanGetOAIDCheckBox.isChecked());
        editor.putBoolean("isCanGetIP", isCanGetIPCheckBox.isChecked());
        editor.putBoolean("isCanUseSensor", isCanUseSensorCheckBox.isChecked());
        editor.putBoolean("isCanUseSimOperator", isCanUseSimOperatorCheckBox.isChecked());
        editor.apply();
    }
}