package com.example.testdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;

import org.json.JSONArray;
import org.json.JSONObject;

import io.dcloud.ads.core.entry.SplashConfig;
import io.dcloud.ads.core.v2.splash.DCSplashAd;
import io.dcloud.ads.core.v2.splash.DCSplashAdListener;
import io.dcloud.ads.core.v2.splash.DCSplashAdLoadListener;

public class SplashActivity extends Activity {

    boolean fromMain = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        if (intent != null)
            fromMain = "MAIN".equals(intent.getStringExtra("FROM"));
        setContentView(R.layout.activity_splash);
        RelativeLayout container = this.findViewById(R.id.splashContainer);
        DCSplashAd splashAd = new DCSplashAd(this);
        // 宽高必传，默认为屏幕宽高
        SplashConfig config = new SplashConfig.Builder()
                .width(getResources().getDisplayMetrics().widthPixels)
                .height((getResources().getDisplayMetrics().heightPixels / 5) * 4) // 高度必须与父视图一致，否则部分广告显示不全
                .build();
        splashAd.setSplashAdListener(new DCSplashAdListener() {
            @Override
            public void onShow() {

            }

            @Override
            public void onClick() {

            }

            @Override
            public void onVideoPlayEnd() {
                toMain();
            }

            @Override
            public void onSkip() {
                toMain();
            }

            @Override
            public void onClose() {
                toMain();
            }

            @Override
            public void onShowError(int i, String s) {
                toMain();
            }
        });
        splashAd.load(config, new DCSplashAdLoadListener() {
            @Override
            public void onSplashAdLoad() {
                splashAd.showIn(container);
            }

            @Override
            public void redBag(@Nullable View view, @Nullable FrameLayout.LayoutParams layoutParams) {

            }

            @Override
            public void onError(int i, String s, @Nullable JSONArray jsonArray) {
                Log.e("打印日志",i+s);
                toMain();
            }
        });
    }

    public void toMain() {
        if (isFinishing() || isDestroyed())
            return;
        if (!fromMain)
            startActivity(new Intent(this, MainActivity.class));
        finish();
    }
}
