package com.example.testdemo.view;

import android.content.Context;
import android.util.AttributeSet;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class RefreshRecyclerView extends RecyclerView {

    private LoadMoreListener listener;
    private boolean isLoading = false;

    public RefreshRecyclerView(@NonNull Context context) {
        super(context);
        init();
    }

    public RefreshRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public RefreshRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    public void setListener(LoadMoreListener listener) {
        this.listener = listener;
    }

    public void setLoadFinish() {
        isLoading = false;
    }

    private void init() {
        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (SCROLL_STATE_IDLE == newState && !isLoading) {
                    RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                    int lastCompletePosition = -1;
                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager) layoutManager;
                    lastCompletePosition = linearLayoutManager.findLastCompletelyVisibleItemPosition();
                    if (lastCompletePosition == layoutManager.getItemCount() - 1) {
                        if (listener != null) {
                            isLoading = true;
                            listener.ONLoadMore();
                        }
                    }
                }
            }
        });
    }

    public interface LoadMoreListener {
        public void ONLoadMore();
    }

}
