# 原生广告接入文档

## 隐私合规说明

尊敬的开发者，您好! 为了帮助使用uni-AD原生广告 Android
SDK的开发者在符合相关法律法规、政策及标准的规定下开展广告业务，更好地落实用户个人信息保护相关要求，特别是保护个人信息和隐私的方法和措施。为了保证您的App顺利通过检测，结合当前监管关注重点，我们制作了合规规范。

[uni-AD原生广告合规规范说明](https://ask.dcloud.net.cn/article/40886)

## 项目集成

### sdk的导入和集成

首先将 uniad-native-release.aar 和 android-gif-drawable-release@1.2.23.aar
拷贝到libs目录下

然后在项目的build.gradle下添加如下依赖

~~~
dependencies {
    implementation fileTree(include: ['*.aar'], dir: './libs')
    implementation 'androidx.appcompat:appcompat:1.2.0'
    implementation "androidx.recyclerview:recyclerview:1.2.0"
	implementation 'com.github.bumptech.glide:glide:4.12.0'
}
~~~

为适配大多数平台，SDK 支持 Android API Level 19+。

#### 增强广告依赖

| SDK 名称		  | 依赖库																																																																																                                                                                                                                                                                                                                         | 支持架构							                    | 说明	 |
|:----------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------|:----|
| 优量汇			    | uniad-gdt-release.aar、GDTSDK.unionNormal.aar																																																																						                                                                                                                                                                                                          | 无要求							                     | 		  |
| 快手			     | uniad-ks-release.aar、ks_adsdk-ad.aar																																																																								                                                                                                                                                                                                                | armeabi-v7a、arm64-v8a、armeabi	 | 		  |
| 百度			     | uniad-bd-release.aar、Baidu_MobAds_SDK.aar																																																																							                                                                                                                                                                                                            | 无要求							                     | 		  |
| sigmob		  | uniad-sgm-release.aar、windAd.aar、wind-common.aar																																																																					                                                                                                                                                                                                       | 无要求							                     | 		  |
| GroMore		 | uniad-gromore-release.aar、open_ad_sdk.aar																																																																							                                                                                                                                                                                                            | armeabi-v7a、arm64-v8a			       | 		  |
| 微信小程序广告	  | uniad-wm-release.aar、implementation "com.tencent.mm.opensdk:wechat-sdk-android:6.8.0"																																																												                                                                                                                                                                           | 无要求							                     | 		  |
| 倍孜			     | beizi*.aar、uniad_bz*.aar																																																																											                                                                                                                                                                                                                         | 无要求							                     | 		  |
| 章鱼			     | octopus*.aar、uniad-zy*.aar																																																																										                                                                                                                                                                                                                        | 无要求							                     | 		  |
| 泛连			     | Funlink*.aar、Funlink_adapter*.aar																																																																									                                                                                                                                                                                                                  | 无要求							                     | 		  |
| 华夏乐游		    | adalliance*.aar、uniad-custom-yt-release.aar、implementation "com.squareup.okhttp3:okhttp:3.12.0"、implementation "com.squareup.okhttp3:logging-interceptor:3.12.0"、implementation "com.google.code.gson:gson:2.8.0"、implementation "com.github.bumptech.glide:glide:4.7.1"、implementation "commons-codec:commons-codec:1.15"	 | 无要求							                     | 		  |

根据uni-AD后台广告开通情况添加增强广告依赖。不包含增强广告模块，只能展示DCloud快捷开屏广告。

#### Android 10 OAID 支持

建议开发者优先集成OAID。Android 10 无法通过常规方式获取IMEI，影响广告测试及正式广告的填充。

MSA联盟官网地址: http://www.msa-alliance.cn/

**注意：当前项目支持Android
X，如果使用的support库，可以参考[文档](https://developer.android.google.cn/jetpack/androidx/)**

**注意：虽然大多数广告平台对架构并没有严格要求，但是部分广告SDK在除arm架构之外的其他架构的手机上不会返回广告**

### sdk对应的第三方支持的广告类型

| SDK名称		| 信息流	| 激励视频	| 全屏视频	| 插屏	| 开屏	| Draw信息流	|
|:----------	|:-----	|:------	|:------	|:----	|:----	|:---------	|
| 优量汇			| ✔		| ✔			| ✔			| ✔		| ✔		| ✔			|
| 快手			| ✔		| ✔			| ✔			| ✔		| ✔		| ✔			|
| 百度			| ✔		| ✔			| ❌			| ✔		| ✔		| ❌			|
| sigmob		| ❌		| ✔			| ✔			| ✔		| ✔		| ❌			|
| GroMore		| ✔		| ✔			| ✔			| ✔		| ✔		| ✔			|
| 微信小程序广告	| ❌		| ✔			| ❌			| ❌		| ❌		| ❌			|
| 倍孜			| ✔		| ❌			| ❌			| ✔		| ✔		| ❌			|
| 章鱼			| ✔		| ✔			| ❌			| ✔		| ✔		| ✔			|
| 泛连			| ✔		| ✔			| ❌			| ✔		| ✔		| ❌			|
| 华夏乐游		| ✔		| ✔			| ❌			| ✔		| ✔		| ❌			|

**注意：自5.1.0.+版本开始，同时集成穿山甲和GroMore会存在冲突，建议只集成GroMore即可。**

### 广告接入

#### 初始化

再请求广告之前，需要先初始化广告，建议在Application#onCreate()方法中调用

```Java
public class App extends Application {
    @Override
    public void onCreate() {
        super.onCreate();
        DCloudAdManager.InitConfig config = new DCloudAdManager.InitConfig();
        config.setAppId("应用id").setAdId("联盟id");
        DCloudAdManager.init(this, config);
    }
}
```

#### 个性化设置

```java

// 是否开启个性化广告 false为关闭个性化推荐，默认为true

DCloudAdManager.setPersonalAd(Context context, boolean isOpen);
```

#### SDK可选个人信息的配置

接入说明：对于SDK可选收集的个人信息的控制，开发者可以通过SDK可选个⼈信息的配置示例说明进⾏配置。如您关闭可选信息的采集，因相关信息的不收集将会影响您使用SDK功能的效果，但不会影响基本功能的实现，请开发者结合业务实际需要进行合理配置。

**注意：setPrivacyConfig需要在init之后立即调用。**

```java
DCloudAdManager.setPrivacyConfig(new DCloudAdManager.PrivacyConfig() {
    /**
     * 是否是成年人；默认为true
     */
    @Override
    public boolean isAdult () {
        return false;
    }

    /**
     * 是否允许SDK主动使用手机硬件参数。默认为true
     */
    @Override
    public boolean isCanUsePhoneState () {
        return false;
    }

    /**
     * 是否允许获取存储权限。默认为true
     */
    @Override
    public boolean isCanUseStorage () {
        return false;
    }

    /**
     * 是否允许获取定位信息。默认为true
     */
    @Override
    public boolean isCanUseLocation () {
        return false;
    }

    /**
     * 是否允许SDK主动使用ACCESS_WIFI_STATE权限。默认为true
     */
    @Override
    public boolean isCanUseWifiState () {
        return false;
    }

    /**
     * 是否允许获取手机app安装列表。默认为true
     */
    @Override
    public boolean isCanGetInstallAppList () {
        return false;
    }

    /**
     * 是否允许获取后台运行的app列表。默认为true
     */
    @Override
    public boolean isCanGetRunningApps () {
        return false;
    }

    /**
     * 是否允许获取mac地址。默认为true
     */
    @Override
    public boolean isCanGetMacAddress () {
        return false;
    }

    /**
     * 是否允许获取androidId。默认为true
     */
    @Override
    public boolean isCanGetAndroidId () {
        return false;
    }

    /**
     * 是否允许获取oaid。默认为true
     */
    @Override
    public boolean isCanGetOAID () {
        return false;
    }

    /**
     * 是否允许获取ip地址。默认为true
     */
    @Override
    public boolean isCanGetIP () {
        return false;
    }

    /**
     * 是否允许使用手机传感器。默认为true
     */
    @Override
    public boolean isCanUseSensor () {
        return false;
    }

    /**
     * 是否允许获取运营商编码。默认为true
     */
    @Override
    public boolean isCanUseSimOperator () {
        return false;
    }

    /**
     * 是否允许使用录音权限。默认为true。
     */
    @Override
    public boolean isCanUseRecordPermission () {
        return false;
    }
});
```

#### 广告位构建

**DCloudAdSlot$Builder**

| 方法名	    | 方法介绍	  | 适用广告类型		     | 默认值					     |
|---------|--------|--------------|--------------|
| adpid	  | 广告位		  | 所有				       | 无						      |
| userId	 | 用户ID		 | 激励视频			      | 无						      |
| extra	  | 额外参数	  | 激励视频			      | 无						      |
| count	  | 广告数量	  | 信息流、draw信息流	 | 3						      |
| width	  | 广告宽度	  | 信息流、draw信息流	 | 屏幕宽度（单位为px）	 |
| height	 | 广告高度	  | draw信息流			   | 默认为0（单位为px）	 |

#### 激励视频

- 主要API

  **DCRewardAd**

  |方法名										|方法介绍			|
  	|--											|--					|
  |setRewardAdListener(DCRewardAdListener)	|设置广告播放监听	|
  |load(DCloudAdSlot,DCRewardAdLoadListener)	|加载广告			|
  |show(Activity)								|展示广告			|
  |destroy()									|销毁广告			|
  |isValid()									|广告是否有效		|

  **DCRewardAdLoadListener**

  |方法名															|方法介绍		|
  	|--																|--				|
  |onRewardAdLoad()												|广告加载成功	|
  |onError(int code, String message, @Nullable JSONArray detail)	|广告加载失败	|

  **DCRewardAdListener**

  |方法名									|方法介绍			|
  	|--										|--					|
  |onReward(JSONObject reward)			|发放奖励时触发		|
  |onShow()								|展示时触发			|
  |onClick()								|点击有效区域时触发	|
  |onVideoPlayEnd()						|视频播放结束时触发	|
  |onSkip()								|点击跳过按钮时触发	|
  |onClose()								|点击关闭按钮时触发	|
  |onShowError(int code, String message)	|播放异常时触发		|

- 服务器回调

  服务端回调是指在用户看完视频达到奖励条件时，服务端会向开发者服务端发送一个验证请求，同时客户端会给出
  onReward
  回调，开发者根据回调进行奖励发放，因为部分平台客户端回调与服务器回调同时触发，所以在onReward中验证奖励时可能会出现验证失败的情况，建议将服务器验证的逻辑放到onClose中。

  目前服务器回调仅支持在uniCloud中使用，具体可参考[文档](https://uniapp.dcloud.io/api/a-d/rewarded-video.html#callback)

  onReward 新增回调参数，返回参数包含provider，为当前广告商

- 示例

```java
DCRewardAd rewardAd = new DCRewardAd(this);
rewardAd.setRewardAdListener(new DCRewardAdListener() {
    @Override
    public void onReward () {
    }

    @Override
    public void onShow () {
    }

    @Override
    public void onClick () {
    }

    @Override
    public void onVideoPlayEnd () {
    }

    @Override
    public void onSkip () {
    }

    @Override
    public void onClose () {
    }

    @Override
    public void onShowError ( int i, String s){
    }
});
DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("测试广告位").build();
        rewardAd.

load(slot, new DCRewardAdLoadListener() {
    @Override
    public void onRewardAdLoad () {
        rewardAd.show(MainActivity.this);
    }

    @Override
    public void onError ( int i, String s, @Nullable JSONArray detail){

    }
});
```

#### 插屏广告

- 主要API

  **DCInterstitialAd**

  |方法名												|方法介绍			|
  	|--													|--					|
  |setInterstitialAdListener(DCInterstitialAdListener)|设置广告播放监听	|
  |load(DCloudAdSlot,DCInterstitialAdLoadListener)	|加载广告			|
  |show(Activity)										|展示广告			|
  |isValid()											|广告是否有效		|

  **DCInterstitialAdLoadListener**

  |方法名															|方法介绍		|
  	|--																|--				|
  |onInterstitialAdLoad()											|广告加载成功	|
  |onError(int code, String message, @Nullable JSONArray detail)	|广告加载失败	|

  **DCInterstitialAdListener**

  |方法名									|方法介绍			|
  	|--										|--					|
  |onShow()								|展示时触发			|
  |onClick()								|点击有效区域时触发	|
  |onVideoPlayEnd()						|视频播放结束时触发	|
  |onSkip()								|点击跳过按钮时触发	|
  |onClose()								|点击关闭按钮时触发	|
  |onShowError(int code, String message)	|播放异常时触发		|

- 示例

```java 
DCInterstitialAd interstitialAd = new DCInterstitialAd(this);
DCloudAdSlot slot = new DCloudAdSlot.Builder().adpid("测试广告位").build();
interstitialAd.load(slot, new DCInterstitialAdLoadListener() {
    @Override
    public void onInterstitialAdLoad () {
        interstitialAd.setInterstitialAdListener(new DCInterstitialAdListener() {
            @Override
            public void onShow() {
            }

            @Override
            public void onClick() {
            }

            @Override
            public void onVideoPlayEnd() {
            }

            @Override
            public void onSkip() {
            }

            @Override
            public void onClose() {
            }

            @Override
            public void onShowError(int i, String s) {
            }
        });
        interstitialAd.show(MainActivity.this);
    }

    @Override
    public void onError ( int i, String s, @Nullable JSONArray detail){
    }
});
```

#### 开屏广告

- 主要API

  **SplashConfig$Builder**

  |方法名		|方法介绍		|默认值		|
  	|--			|--				|--			|
  |width()	|开屏广告宽度	|屏幕宽度	|
  |height()	|开屏广告高度	|屏幕高度	|

  **注意：宽高一定要按照开屏广告的容器来赋值，否则会出现广告显示不全的情况**

  **DCSplashAd**

  |方法名										|方法介绍			|
  	|--											|--					|
  |setSplashAdListener(DCSplashAdListener)	|设置广告播放监听	|
  |load(SplashConfig,DCSplashAdLoadListener)	|加载广告			|
  |showIn(ViewGroup)							|展示广告			|
  |isValid()									|广告是否有效		|

  **DCSplashAdLoadListener**

  |方法名															|方法介绍				|
  	|--																|--						|
  |onSplashAdLoad()												|广告加载成功			|
  |pushAd(JSONObject jsonObject)									|推送广告（暂不支持）	|
  |redBag(View view, FrameLayout.LayoutParams layoutParams)		|红包广告（暂不支持）	|
  |onError(int code, String message, @Nullable JSONArray detail)	|广告加载失败			|

  **DCInterstitialAdListener**

  |方法名									|方法介绍			|
  	|--										|--					|
  |onShow()								|展示时触发			|
  |onClick()								|点击有效区域时触发	|
  |onVideoPlayEnd()						|视频播放结束时触发	|
  |onSkip()								|点击跳过按钮时触发	|
  |onClose()								|点击关闭按钮时触发	|
  |onShowError(int code, String message)	|播放异常时触发		|

- 示例

```java
RelativeLayout container = this.findViewById(R.id.splashContainer);
DCSplashAd splashAd = new DCSplashAd(this);
// 宽高必传，默认为屏幕宽高
SplashConfig config = new SplashConfig.Builder()
        .width(getResources().getDisplayMetrics().widthPixels)
        .height((getResources().getDisplayMetrics().heightPixels / 5) * 4)
        // 高度必须与父视图一致，否则部分广告显示不全
        .build();
splashAd.setSplashAdListener(new DCSplashAdListener() {
    @Override
    public void onShow () {

    }

    @Override
    public void onClick () {

    }

    @Override
    public void onVideoPlayEnd () {
        toMain();
    }

    @Override
    public void onSkip () {
        toMain();
    }

    @Override
    public void onClose () {
        toMain();
    }

    @Override
    public void onShowError ( int i, String s){
        toMain();
    }
});
        splashAd.

load(config, new DCSplashAdLoadListener() {
    @Override
    public void onSplashAdLoad () {
        splashAd.showIn(container);
    }

    @Override
    public void onError ( int i, String s, @Nullable JSONArray detail){
        toMain();
    }
});
```

#### 信息流广告

- 主要API

  **DCFeedAdLoader**

  |方法名										|方法介绍			|
  	|--											|--					|
  |load(SplashConfig,DCFeedAdLoadListener)	|加载广告			|

  **DCFeedAdLoadListener**

  |方法名															|方法介绍		|
  	|--																|--				|
  |onFeedAdLoad(List<DCFeedAd>)									|广告加载成功	|
  |onError(int code, String message, @Nullable JSONArray detail)	|广告加载失败	|

  **DCFeedAd**

  |方法名								|方法介绍							|
  	|--									|--									|
  |render()							|渲染广告							|
  |getFeedAdView(Activity)			|获取广告视图(需要在渲染成功后调用)	|
  |destroy()							|销毁广告							|
  |setFeedAdListener(DCFeedAdListener)|设置信息流监听						|

  **DCFeedAdListener**

  |方法名				|方法介绍					|
  	|--					|--							|
  |onRenderSuccess()	|渲染成功					|
  |onRenderFail()		|渲染失败					|
  |onShow()			|展示时触发					|
  |onClick()			|点击有效区域时触发			|
  |onSkip()			|点击跳过按钮时触发			|
  |onClose(String)	|关闭时触发					|
  |onShowError()		|渲染异常或者加载异常时触犯	|

- 示例

  参考sdk示例中的FeedActivity

#### Draw视频流广告

- 主要API

  **DCDrawAdLoader**

  |方法名									|方法介绍	|
  	|--										|--			|
  |load(SplashConfig,DCDrawAdLoadListener)|加载广告	|

  **DCDrawAdLoadListener**

  |方法名															|方法介绍		|
  	|--																|--				|
  |onDrawAdLoad(List<DCDrawAd>)									|广告加载成功	|
  |onError(int code, String message, @Nullable JSONArray detail)	|广告加载失败	|

  **DCDrawAd**

  |方法名								|方法介绍							|
  	|--									|--									|
  |render()							|渲染广告							|
  |getDrawAdView(Activity)			|获取广告视图(需要在渲染成功后调用)	|
  |destroy()							|销毁广告							|
  |setDrawAdListener(DCDrawAdListener)|设置信息流监听						|

  **DCDrawAdListener**

  |方法名				|方法介绍					|
  	|--					|--							|
  |onRenderSuccess()	|渲染成功					|
  |onRenderFail()		|渲染失败					|
  |onShow()			|展示时触发					|
  |onClick()		|点击有效区域时触发			|
  |onSkip()			|点击跳过按钮时触发			|
  |onClose(String)	|关闭时触发					|
  |onShowError()		|渲染异常或者加载异常时触犯	|
  |onStart()			|开始播放					|
  |onPause()			|播放暂停					|
  |onResume()			|恢复播放					|
  |onEnd()			|播放结束					|

- 示例

  参考sdk示例中的DrawActivity