export interface UTSJSONObject {
  get(key: string): ESObject | null;
  set(key: string, value: ESObject): void;
  getAny(key: string, def?: undefined | null): ESObject | null
  getAny(key: string, def: ESObject): ESObject
  getBoolean(key: string, def?: undefined | null): boolean | null
  getBoolean(key: string, def: boolean): boolean
  getNumber(key: string, def?: undefined | null): number | null
  getNumber(key: string, def: number): number
  getString(key: string, def?: undefined | null): string | null
  getString(key: string, def: string): string
  getJSON(key: string, def?: undefined | null): UTSJSONObject | null
  getJSON(key: string, def: UTSJSONObject): UTSJSONObject
  getArray<T = ESObject>(key: string, def?: undefined | null): Array<T>  | null
  getArray<T = ESObject>(key: string, def: Array<T>): Array<T>
  toMap(): Map<string, ESObject>;
}

interface UTSJSONObjectConstructor {
  prototype: UTSJSONObject;
  new(content?: ESObject): UTSJSONObject;
  keys(item: UTSJSONObject): Array<string>;
  assign(...items: UTSJSONObject[]): UTSJSONObject;
  assign<T>(...items: ESObject[]): T;
}

export const UTSJSONObject = globalThis.UTSJSONObject as UTSJSONObjectConstructor

export interface IUTSObject extends Record<string, ESObject> { }

export class UTSObject implements IUTSObject {
  constructor(content?: ESObject) {
    if(content) {
      for (const key in content) {
        this[key] = content[key]
      }
    }
  }
}

export {
  resolveInOperator,
  IJSONStringify,
  IUTSDefaultGenericParent
} from './uts-helper'